/*
 * Decompiled with CFR 0.152.
 */
package oolloo.jlw;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import oolloo.jlw.ArgParser;
import oolloo.jlw.CimCommandLineLoader;
import oolloo.jlw.ClassPathInjector;
import oolloo.jlw.NativeCommandLineLoader;

public class Wrapper {
    static final String NATIVE_VERSION = "1.4.3";
    static final boolean DEBUG = System.getProperty("oolloo.jlw.debug", "").equals("true");

    public static void main(String[] originArgs) throws Throwable {
        String commandLine;
        if (DEBUG) {
            Wrapper.debug("=====  Origin  =====");
            Wrapper.debug(String.format("App Arguments: %s", Arrays.toString(originArgs)));
            Wrapper.debug("System Properties:");
            Set<Map.Entry<Object, Object>> s = System.getProperties().entrySet();
            for (Map.Entry<Object, Object> e : s) {
                Wrapper.debug(String.format("  %s", e));
            }
            Wrapper.debug("====================");
        }
        try {
            commandLine = new NativeCommandLineLoader().load();
        }
        catch (Throwable e1) {
            if (e1 instanceof Error && !(e1 instanceof UnsatisfiedLinkError)) {
                throw e1;
            }
            Wrapper.debug("native command line loader failed with exception:");
            Wrapper.debug(e1.getMessage());
            Wrapper.debug("try cim command line loader.");
            try {
                commandLine = new CimCommandLineLoader().load();
            }
            catch (Exception e2) {
                Wrapper.debug("cim command line loader failed with exception:");
                Wrapper.debug(e2.getMessage());
                throw new Exception("All CommandLine Loaders Failed.");
            }
        }
        Wrapper.debug(String.format("got command line: %s", commandLine));
        Object[] args = ArgParser.parse(commandLine);
        Wrapper.debug(String.format("got raw args: %s", Arrays.toString(args)));
        int pos = 1;
        int len = args.length;
        Object clazzMain = null;
        String[] argsOut = null;
        do {
            Object flag = args[pos++];
            Object arg = "";
            if (((String)flag).charAt(0) != '-') continue;
            int eqPos = ((String)flag).indexOf(61);
            if (eqPos > -1) {
                arg = ((String)flag).substring(eqPos + 1);
                flag = ((String)flag).substring(0, eqPos);
            } else if (((String)args[pos]).charAt(0) != '-') {
                arg = args[pos];
            }
            if (((String)flag).startsWith("-D")) {
                System.setProperty(((String)flag).substring(2), (String)arg);
                continue;
            }
            if ("-cp".equals(flag) || "--classpath".equals(flag) || "--class-path".equals(flag)) {
                System.setProperty("java.class.path", (String)arg);
                for (String path : ((String)arg).split(File.pathSeparator)) {
                    ClassPathInjector.appendClassPath(path);
                }
            } else {
                if (!"-jar".equals(flag)) continue;
                int n = ++pos;
                clazzMain = args[n];
                int lenOut = len - ++pos;
                argsOut = new String[lenOut];
                System.arraycopy(args, pos, argsOut, 0, lenOut);
                pos = len;
            }
        } while (pos < len);
        if (DEBUG) {
            Wrapper.debug("===== Injected =====");
            Wrapper.debug(String.format("Main Class: %s", clazzMain));
            Wrapper.debug(String.format("App Arguments: %s", Arrays.toString(argsOut)));
            Wrapper.debug("System Properties:");
            Set<Map.Entry<Object, Object>> s = System.getProperties().entrySet();
            for (Map.Entry<Object, Object> e : s) {
                Wrapper.debug(String.format("  %s", e));
            }
            Wrapper.debug("====================");
        }
        Wrapper.invokeMain(clazzMain, argsOut);
    }

    private static void invokeMain(String mainClass, String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(mainClass);
        Method main = clazz.getDeclaredMethod("main", String[].class);
        main.setAccessible(true);
        main.invoke(null, new Object[]{args});
    }

    static void debug(String msg) {
        if (DEBUG) {
            System.out.println("jlw: " + msg);
        }
    }
}

